//
//  File.swift
//  EcoWarriors
//
//  Created by Ria on 14/08/19.
//  Copyright © 2019 Ria. All rights reserved.
//

import UIKit

class JOTController: UIViewController{
    
    //MARK:- viewDidLoad()
    
    override func viewDidLoad() {
        super.viewDidLoad()
        
        setupScrollView()
        pageSetup()

    }
    
    //MARK:- Page Setup
    
    func pageSetup() {
        
        let vgPicture = UIImageView()
        vgPicture.image = #imageLiteral(resourceName: "JOTpic.png")
        vgPicture.frame = CGRect(x: screenWidth/2-300, y: 65, width: 600, height: 470)
        vgPicture.layer.cornerRadius = 5
        vgPicture.clipsToBounds = true
        self.scrollView.addSubview(vgPicture)
        
        let moreButton = UIButton()
               moreButton.frame = CGRect(x: 0, y: 0, width: screenWidth-20, height: 40)
               moreButton.center = CGPoint(x: screenWidth/2, y: 640)
               moreButton.backgroundColor = .mainBlue()
               moreButton.layer.cornerRadius = 15
               moreButton.setTitle("Join the EcoWarriors now!", for: .normal)
               moreButton.clipsToBounds = true
               moreButton.addTarget(self, action: #selector(joinNow), for: .touchUpInside)
               self.scrollView.addSubview(moreButton)
      
        let Quote = UILabel()
        Quote.frame = CGRect(x: screenWidth/2-150, y: 500,width:300,height: 150)
        Quote.textAlignment = NSTextAlignment.center
        Quote.text = "We are the last generation with a real opportunity to save the world. Click below to make the world a better place."
        Quote.numberOfLines = 10
        Quote.lineBreakMode = .byWordWrapping
        Quote.textColor = .black
        Quote.font = UIFont(name: "HelveticaNeue-LightItalic", size: 17)
        self.scrollView.addSubview(Quote)
        
        //MARK:- Navigation Bar
        
        self.navigationItem.title = "Join our team"
        navigationController?.navigationBar.barTintColor = .mainBlue()
        navigationController?.navigationBar.barStyle = .black
        navigationItem.leftBarButtonItem = UIBarButtonItem(image: #imageLiteral(resourceName: "Cross").withRenderingMode(.alwaysOriginal), style: .plain, target: self, action: #selector(handleDismiss))
        navigationItem.rightBarButtonItem = UIBarButtonItem(image:#imageLiteral(resourceName: "logo1").withRenderingMode(.alwaysOriginal), style: .plain , target: self, action: #selector(doNothing))
    }
    
    //MARK:- Page Functions
    
    @objc func joinNow() {
           if let url = URL(string: "https://forms.gle/SH8iPC6P7AdC5s898") {
               UIApplication.shared.open(url)
           }
       }
    
    @objc func handleDismiss() {
        dismiss(animated: true, completion: nil)
    }
    
    @objc func doNothing(_ sender:UIButton!) {
        
    }
    
    //MARK:- Scroll View
    
    lazy var scrollView: UIScrollView = {
        let view = UIScrollView()
        view.translatesAutoresizingMaskIntoConstraints = false
        view.contentSize.height = 850
        view.backgroundColor = .white
        return view
    }()
    
    func setupScrollView() {
        view.addSubview(scrollView)
        scrollView.topAnchor.constraint(equalTo: view.topAnchor).isActive = true
        scrollView.bottomAnchor.constraint(equalTo: view.bottomAnchor).isActive = true
        scrollView.leftAnchor.constraint(equalTo: view.leftAnchor).isActive = true
        scrollView.rightAnchor.constraint(equalTo: view.rightAnchor).isActive = true
    }
}
